/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

// Line Convenience Functions

#include <StdAfx.h>
#include "funcheader.h"
#include "CConvenienceExports.h"

HRESULT GetCreateLineInput(double *startX, double *startY, double *endX, double *endY)
{

	START_METHOD("GetCreateLineInput")

	// this can be replaced with a dialog box
	*startX = -0.1;
	*startY = 0.1;
	*endX = 0.1;
	*endY = -0.1;

	END_METHOD("GetCreateLineInput")
}

HRESULT GetCreateCircleInput(double *centerX, double *centerY, double *radius)
{

	START_METHOD("GetCreateCircleInput")

	// this can be replaced with a dialog box
	*centerX = 0;
	*centerY = 0;
	*radius = 0.05;

	END_METHOD("GetCreateCircleInput")
}

HRESULT GetCreateRectangleInput(double *startX, double *startY, double *endX, double *endY)
{

	START_METHOD("GetCreateRectangleInput")

	// this can be replaced with a dialog box
	*startX = -0.1;
	*startY = 0.1;
	*endX = 0.1;
	*endY = -0.1;

	END_METHOD("GetCreateRectangleInput")
}

HRESULT GetCreateArcStartEndCenterInput(IPoint **startPoint, IPoint **endPoint,
																				IPoint **centerPoint)
{

	START_METHOD("GetCreateArcStartEndCenterInput")

	HRESULT status = CONV_SUCCESS;

	// this can be replaced with a dialog box
	double startX = -0.1;
	double startY = 0.1;
	double endX = 0.1;
	double endY = -0.1;
	double midX = (startX + endX) / 2 ;
	double midY = (startY + endY) / 2 ;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	// Create the startVector
	IVector *startVector2D = NULL;
	status = (GetCLASS(Vector))->CreateVector(startX, startY, 0, &startVector2D);
	CHECK_RETURN_STATUS(status)

	// Get the 3D vector for startVector
	IVector *startVector3D = NULL;
	status = activeWorkplane->Get3DVector(startVector2D, &startVector3D);
	CHECK_RETURN_STATUS(status)

	// Create the midVector
	IVector *midVector2D = NULL;
	status = (GetCLASS(Vector))->CreateVector(midX, midY, 0, &midVector2D);
	CHECK_RETURN_STATUS(status)

	// Get the 3D vector for midVector
	IVector *midVector3D = NULL;
	status = activeWorkplane->Get3DVector(midVector2D, &midVector3D);
	CHECK_RETURN_STATUS(status)

	// Create the endVector
	IVector *endVector2D = NULL;
	status = (GetCLASS(Vector))->CreateVector(endX, endY, 0, &endVector2D);
	CHECK_RETURN_STATUS(status)

	// Get the 3D vector for endVector
	IVector *endVector3D = NULL;
	status = activeWorkplane->Get3DVector(endVector2D, &endVector3D);
	CHECK_RETURN_STATUS(status)
	
	//	Create a temporary line1

	// Create basic straight line
	IBasicStraight *curve1 = NULL;
	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(startVector3D, midVector3D, &curve1);
	CHECK_RETURN_STATUS(status)

	// Create aLine object
	ILine *line1 = NULL;
	status = activeSketch->CreateLine(CAST(ICurve, curve1), &line1);
	CHECK_RETURN_STATUS(status)

	// Create basic straight line
	IBasicStraight *curve2 = NULL;
	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(midVector3D, endVector3D, &curve2);
	CHECK_RETURN_STATUS(status)

	// Create aLine object
	ILine *line2 = NULL;
	status = activeSketch->CreateLine(CAST(ICurve, curve2), &line2);
	CHECK_RETURN_STATUS(status)

	// Get the start point for the arc to be created
	IPoint *start = NULL;
	status = line1->GetStartPoint(&start);
	CHECK_RETURN_STATUS(status)
	*startPoint = start;

	// Get the end point for the arc to be created
	IPoint *end = NULL;
	status = line2->GetEndPoint(&end);
	CHECK_RETURN_STATUS(status)
	*endPoint = end;

	// Get the center for the arc to be created
	IPoint *center = NULL;
	status = line1->GetEndPoint(&center);
	CHECK_RETURN_STATUS(status)
	*centerPoint = center;

	// Create a set of lines
	ISet *aLineSet1 = NULL;
	status = (GetCLASS(ObjectSet))->CreateAObjectSet(&aLineSet1);
	CHECK_RETURN_STATUS(status)

	// Add those two temporary lines ( created above ) to the set
	status = aLineSet1->AddMember(line1);
	CHECK_RETURN_STATUS(status)

	status = aLineSet1->AddMember(line2);
	CHECK_RETURN_STATUS(status)

	// Set the selection to the object set
	status = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, aLineSet1));
	CHECK_RETURN_STATUS(status)

	// Delete the selection
	status = activeGraphicDoc->DeleteSelection();
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetCreateArcStartEndCenterInput")
}
